/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DPRecipeSerializer;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.compat.gloopy.GloopyUtils;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import dev.architectury.platform.Platform;
import net.minecraft.class_1715;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class KeyboardRecipe
extends class_1852 {
    private static final class_1856 KEYBOARD = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)DuckyPeriphs.KEYBOARD_ITEM.get()});
    private static final class_1856 SOLVENTS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8554, class_1802.field_8705});

    public KeyboardRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    public boolean matches(class_8566 craftingInventory, class_1937 world) {
        int width = craftingInventory.method_17398();
        int height = craftingInventory.method_17397();
        boolean foundChanger = false;
        int minChangerX = 0;
        int minChangerY = 0;
        int maxChangerX = 0;
        int maxChangerY = 0;
        int keyboardCount = 0;
        int keyboardX = 0;
        int keyboardY = 0;
        for (int s = 0; s < width * height; ++s) {
            int x = s % width;
            int y = s / width;
            class_1799 stack = craftingInventory.method_5438(s);
            if (KEYBOARD.method_8093(stack)) {
                keyboardX = x;
                keyboardY = y;
                if (++keyboardCount <= 1) continue;
                return false;
            }
            if (!SOLVENTS.method_8093(stack) && !(stack.method_7909() instanceof class_1769) && (!Platform.isModLoaded((String)"hexgloop") || !GloopyUtils.isGloopDye(stack))) continue;
            if (!foundChanger) {
                foundChanger = true;
                minChangerX = x;
                minChangerY = y;
                maxChangerX = x;
                maxChangerY = y;
                continue;
            }
            minChangerX = Math.min(minChangerX, x);
            minChangerY = Math.min(minChangerY, y);
            maxChangerX = Math.max(maxChangerX, x);
            maxChangerY = Math.max(maxChangerY, y);
        }
        if (keyboardCount == 0) {
            return false;
        }
        if (!foundChanger) {
            return false;
        }
        return Math.abs(keyboardX - minChangerX) <= 2 && Math.abs(keyboardY - minChangerY) <= 2 && Math.abs(keyboardX - maxChangerX) <= 2 && Math.abs(keyboardY - maxChangerY) <= 2;
    }

    public class_1799 craft(class_8566 craftingInventory, class_5455 dynRegManager) {
        int width = craftingInventory.method_17398();
        int height = craftingInventory.method_17397();
        int keyboardX = 0;
        int keyboardY = 0;
        class_1799 kbStack = class_1799.field_8037;
        for (int s = 0; s < width * height; ++s) {
            int x = s % width;
            int y = s / width;
            class_1799 stack = craftingInventory.method_5438(s);
            if (!KEYBOARD.method_8093(stack)) continue;
            keyboardX = x;
            keyboardY = y;
            kbStack = stack.method_7972();
            break;
        }
        KeyCaps keyCaps = KeyCaps.fromItemStack(kbStack);
        for (int s = 0; s < width * height; ++s) {
            int craftingGridIndex;
            int x = s % width;
            int y = s / width;
            class_1799 stack = craftingInventory.method_5438(s);
            if (SOLVENTS.method_8093(stack)) {
                craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
                keyCaps.removeColor(craftingGridIndex);
                continue;
            }
            if (stack.method_7909() instanceof class_1769) {
                craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
                float[] thisColorComps = ((class_1769)stack.method_7909()).method_7802().method_7787();
                int thisColor = (int)(thisColorComps[0] * 255.0f) << 16 | (int)(thisColorComps[1] * 255.0f) << 8 | (int)(thisColorComps[2] * 255.0f);
                keyCaps.blendAndSetColor(thisColor, craftingGridIndex);
                continue;
            }
            if (!Platform.isModLoaded((String)"hexgloop") || !GloopyUtils.isGloopDye(stack)) continue;
            craftingGridIndex = this.gridIndex(x, y, keyboardX, keyboardY);
            int thisColor = GloopyUtils.getGloopDyeColor(stack);
            keyCaps.blendAndSetColor(thisColor, craftingGridIndex);
        }
        kbStack.method_7959("key_caps", (class_2520)keyCaps.toSubNBT());
        return kbStack;
    }

    public class_2371<class_1799> getRemainder(class_1715 inventory) {
        class_2371 defaultedList = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1792 item = inventory.method_5438(i).method_7909();
            if (item == class_1802.field_8554) {
                defaultedList.set(i, (Object)inventory.method_5438(i));
            } else if (item == class_1802.field_8705) {
                defaultedList.set(i, (Object)new class_1799((class_1935)class_1802.field_8550));
            } else if (Platform.isModLoaded((String)"hexgloop") && GloopyUtils.isGloopDye(inventory.method_5438(i))) {
                class_1799 stack = inventory.method_5438(i).method_7972();
                GloopyUtils.useGloopMedia(stack);
                defaultedList.set(i, (Object)stack);
            }
            if (!item.method_7857()) continue;
            defaultedList.set(i, (Object)new class_1799((class_1935)item.method_7858()));
        }
        return defaultedList;
    }

    private int gridIndex(int c_x, int c_y, int kb_x, int kb_y) {
        int x = c_x - kb_x + 2;
        int y = c_y - kb_y + 2;
        return x + 5 * y;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1865<?> method_8119() {
        return (class_1865)DPRecipeSerializer.KEYBOARD_RECIPE.get();
    }

    public boolean method_8118() {
        return true;
    }
}

